﻿# Calebs Roofing â€” Sitemap & Wireframe Blueprint

## 1) Full Sitemap

### Primary navigation
1. **Home** (`/`)
2. **Services** (`/services`)
   - Roof Repair (`/services/roof-repair`)
   - Roof Replacement (`/services/roof-replacement`)
   - Storm Damage Restoration (`/services/storm-damage`)
   - Gutters & Ventilation (`/services/gutters-ventilation`)
   - Commercial Roofing (`/services/commercial-roofing`)
3. **Portfolio** (`/portfolio`)
4. **Reviews** (`/reviews`)
5. **Service Areas** (`/service-areas`)
   - City page template (`/service-areas/{city}`)
6. **Financing** (`/financing`)
7. **About** (`/about`)
8. **Contact** (`/contact`)
9. **Schedule Appointment** (`/schedule`)
10. **Free Estimate** (`/free-estimate`)

### Utility pages
- FAQ (`/faq`)
- Careers (`/careers`)
- Warranty (`/warranty`)
- Privacy Policy (`/privacy-policy`)
- Terms (`/terms`)

### SEO support structure
- Service x City landing pages (`/{city}/{service}`)
- Project case studies (`/projects/{project-name}`)
- Educational blog hub (`/blog`)

---

## 2) Homepage Wireframe Outline (Section by Section)

### A. Sticky top bar
- Left: Phone number with click-to-call
- Right: "24/7 Emergency Service" + service area

### B. Main header
- Logo
- Navigation links
- Primary CTA: **Get Free Estimate**
- Secondary CTA: **Schedule Appointment**

### C. Hero section
- Headline focused on trust and local credibility
- Subheadline focused on outcomes (durability, protection, speed)
- Buttons:
  - Get Free Estimate
  - Book Roof Inspection
- Hero image of professional roofing work
- Trust badges row: Licensed, Insured, 5-Star Rated, Warranty-backed

### D. Social proof / ratings block
- Aggregate rating (example: 4.9/5)
- Review count
- Platform chips (Google, Facebook, Angi)
- 2â€“3 featured testimonial cards

### E. Services overview
- 4â€“6 service cards
- Short value points
- Links to service detail pages

### F. Portfolio (before/after style)
- Visual gallery cards with labels (repair, replacement, storm)
- Short project context (location + roof type)
- CTA: "View Full Portfolio"

### G. Process section (3-step)
1. Free inspection
2. Detailed estimate
3. Professional installation + cleanup

### H. Why choose us
- Metrics: years in business, roofs completed, average response time
- Differentiators: manufacturer-certified crews, transparent pricing

### I. Service area mini map/list
- Key cities + nearby neighborhoods
- CTA to see all service areas

### J. Final CTA strip
- "Need help now?"
- Buttons: Call now, Schedule appointment, Get free estimate

### K. Footer
- Contact info (NAP)
- Quick links
- Review snippet
- Licensing and insurance statement

---

## 3) Conversion & UX Rules for Best Performance

- **One primary CTA repeated** in hero, mid-page, footer.
- **Sticky call button on mobile** for older users and fast conversions.
- Keep estimate form to **3â€“5 required fields** maximum.
- Use large, high-contrast text and clear buttons for accessibility.
- Every section should answer one question:
  - Can I trust you?
  - What do you do?
  - Have you done this before?
  - How fast can I get help?

---

## 4) SEO Essentials Embedded in Design

- Single H1 with local keyword intent.
- LocalBusiness + Service + Review structured data.
- Internal links from homepage to each service and city page.
- Optimized image alt text for roofing intent + city.
- Dedicated pages for each high-value service and location.

---

## 5) Recommended Next Build Sequence

1. Build homepage and global components.
2. Build service page template and publish 5 service pages.
3. Build 5 top-priority city pages.
4. Add portfolio case study pages.
5. Launch tracking for calls, form submissions, and appointment bookings.

