(() => {
  const clamps = (value, min, max) => Math.min(max, Math.max(min, value));
  const prefersReducedMotion = window.matchMedia("(prefers-reduced-motion: reduce)").matches;

  const initCompare = (root) => {
    const slider = root.querySelector("[data-compare-slider]");
    const after = root.querySelector("[data-compare-after]");
    const handle = root.querySelector("[data-compare-handle]");
    const divider = root.querySelector(".compare-divider");
    if (!slider || !after || !handle) return;

    let dragging = false;
    let currentPercent = 50;
    let targetPercent = 50;
    let rafId = 0;

    const setPosition = (percent) => {
      const value = clamps(percent, 8, 92);
      currentPercent = value;
      after.style.width = `${value}%`;
      handle.style.left = `${value}%`;
      if (divider) divider.style.left = `${value}%`;
    };

    const runFrame = () => {
      rafId = 0;
      setPosition(targetPercent);
    };

    const scheduleFrame = () => {
      if (rafId) return;
      rafId = window.requestAnimationFrame(runFrame);
    };

    const eventToPercent = (event) => {
      const rect = slider.getBoundingClientRect();
      if (!rect.width) return 50;
      return ((event.clientX - rect.left) / rect.width) * 100;
    };

    const onMove = (event) => {
      if (!dragging) return;
      targetPercent = eventToPercent(event);
      scheduleFrame();
    };

    const onUp = () => {
      if (!dragging) return;
      dragging = false;
      root.classList.remove("is-dragging");
      window.removeEventListener("pointermove", onMove);
      window.removeEventListener("pointerup", onUp);
    };

    const onDown = (event) => {
      dragging = true;
      root.classList.add("is-dragging");
      targetPercent = eventToPercent(event);
      scheduleFrame();
      window.addEventListener("pointermove", onMove, { passive: true });
      window.addEventListener("pointerup", onUp, { passive: true });
    };

    slider.addEventListener("pointerdown", onDown);
    handle.addEventListener("keydown", (event) => {
      if (event.key === "ArrowLeft") {
        event.preventDefault();
        targetPercent = currentPercent - 2;
        scheduleFrame();
      }
      if (event.key === "ArrowRight") {
        event.preventDefault();
        targetPercent = currentPercent + 2;
        scheduleFrame();
      }
    });

    setPosition(50);

    if (!prefersReducedMotion) {
      setTimeout(() => {
        targetPercent = 55;
        scheduleFrame();
        setTimeout(() => {
          targetPercent = 50;
          scheduleFrame();
        }, 500);
      }, 120);
    }
  };

  document.querySelectorAll("[data-compare]").forEach(initCompare);
})();
